/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.PerformanceMetrics;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class PerformanceMetric {
    private final String name;
    private long timeStarted = 0L;
    private int interrupted = 0;
    private final RunningTotal runningTotal = new RunningTotal();
    private ArrayList<Threshold> thresholds = new ArrayList();

    PerformanceMetric(PerformanceMetrics metrics, String name, double ... thresholds) {
        this.name = name;
        for (double threshold : thresholds) {
            this.thresholds.add(new Threshold(threshold));
        }
        metrics.addMetric(this);
    }

    public RunningTotal getRunningTotal() {
        return this.runningTotal;
    }

    public int getInterrupted() {
        return this.interrupted;
    }

    void time(Runnable runnable) {
        this.startTiming();
        runnable.run();
        this.stopTiming();
    }

    void timeIf(boolean condition, Runnable runnable) {
        if (condition) {
            this.time(runnable);
        } else {
            runnable.run();
        }
    }

    void startTiming() {
        if (this.timeStarted > 0L) {
            ++this.interrupted;
        }
        this.timeStarted = System.nanoTime();
    }

    void stopTiming() {
        if (this.timeStarted <= 0L) {
            return;
        }
        long timeEnded = System.nanoTime();
        long timeDiff = timeEnded - this.timeStarted;
        this.timeStarted = 0L;
        this.record((double)timeDiff / 1000000.0);
    }

    void record(double value) {
        this.runningTotal.record(value);
        this.thresholds.forEach(threshold -> threshold.record(value));
    }

    public String toString() {
        if (this.runningTotal.samples <= 0) {
            return this.name + ": No samples.";
        }
        DecimalFormat formatter = new DecimalFormat("###,###.#");
        String output = this.name + ":\n" + formatter.format(this.runningTotal.samples) + " samples averaging " + formatter.format(this.runningTotal.mean) + " [" + formatter.format(this.runningTotal.min) + " - " + formatter.format(this.runningTotal.max) + "]";
        for (Threshold threshold : this.thresholds) {
            output = output + threshold.toString();
        }
        if (this.interrupted > 0) {
            output = output + "\n\tInterrupted " + this.interrupted + " times";
        }
        return output;
    }

    class Threshold {
        double threshold;
        RunningTotal runningTotal;

        Threshold(double value) {
            this.runningTotal = new RunningTotal();
            this.threshold = value;
        }

        void record(double value) {
            if (value >= this.threshold) {
                this.runningTotal.record(value);
            }
        }

        public String toString() {
            if (this.runningTotal.samples <= 0) {
                return "";
            }
            DecimalFormat formatter = new DecimalFormat("###,###.#");
            return "\n>= " + formatter.format(this.threshold) + ": " + this.runningTotal.samples + " samples averaging " + formatter.format(this.runningTotal.mean);
        }
    }

    public class RunningTotal {
        private int samples = 0;
        private double last = 0.0;
        private double mean = 0.0;
        private double min = 9.223372036854776E18;
        private double max = -9.223372036854776E18;

        void record(double value) {
            this.last = value;
            this.min = Math.min(this.min, value);
            this.max = Math.max(this.max, value);
            this.mean = (this.mean * (double)this.samples + value) / ((double)this.samples + 1.0);
            ++this.samples;
        }

        public double getSamples() {
            return this.samples;
        }

        public double getLast() {
            return this.last;
        }

        public double getMean() {
            return this.mean;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }
    }
}

