/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.BulletType;
import bwapi.ClientData;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import java.util.Objects;

public final class Bullet
implements Comparable<Bullet> {
    private final ClientData.BulletData bulletData;
    private final int id;
    private final Game game;

    Bullet(ClientData.BulletData bulletData, int id, Game game) {
        this.bulletData = bulletData;
        this.id = id;
        this.game = game;
    }

    public int getID() {
        return this.id;
    }

    public boolean exists() {
        return this.bulletData.getExists();
    }

    public Player getPlayer() {
        return this.game.getPlayer(this.bulletData.getPlayer());
    }

    public BulletType getType() {
        return BulletType.idToEnum[this.bulletData.getType()];
    }

    public Unit getSource() {
        return this.game.getUnit(this.bulletData.getSource());
    }

    public Position getPosition() {
        return new Position(this.bulletData.getPositionX(), this.bulletData.getPositionY());
    }

    public double getAngle() {
        return this.bulletData.getAngle();
    }

    public double getVelocityX() {
        return this.bulletData.getVelocityX();
    }

    public double getVelocityY() {
        return this.bulletData.getVelocityY();
    }

    public Unit getTarget() {
        return this.game.getUnit(this.bulletData.getTarget());
    }

    public Position getTargetPosition() {
        return new Position(this.bulletData.getTargetPositionX(), this.bulletData.getTargetPositionY());
    }

    public int getRemoveTimer() {
        return this.bulletData.getRemoveTimer();
    }

    public boolean isVisible() {
        return this.isVisible(this.game.self());
    }

    public boolean isVisible(Player player) {
        if (player == null) {
            return this.isVisible();
        }
        return this.bulletData.isVisible(player.getID());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bullet bullet = (Bullet)o;
        return this.id == bullet.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public int compareTo(Bullet other) {
        return this.id - other.id;
    }
}

