/*
 * Decompiled with CFR 0.152.
 */
package Strategery.History;

import Lifecycle.With$;
import Strategery.History.HistoricalGame;
import Utilities.CountMap;
import Utilities.CountMap$;
import bwapi.Race;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.Ordering$Long$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HistorySerializer$ {
    public static HistorySerializer$ MODULE$;
    private final int formatVersion;
    private final String separator;

    static {
        new HistorySerializer$();
    }

    public int formatVersion() {
        return this.formatVersion;
    }

    public String separator() {
        return this.separator;
    }

    public Vector<HistoricalGame> readGames(Iterable<String> serializedHistory) {
        return ((TraversableOnce)serializedHistory.flatMap((Function1<String, Iterable> & Serializable & scala.Serializable)serializedGame -> Option$.MODULE$.option2Iterable(MODULE$.readGame((String)serializedGame)), Iterable$.MODULE$.canBuildFrom())).toVector();
    }

    private Option<HistoricalGame> readGame(String serializedGame) {
        try {
            return new Some<HistoricalGame>(this.readGameFromColumns((String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])serializedGame.replaceAll(",,,", this.separator()).split(this.separator()))).map((Function1<String, String> & Serializable & scala.Serializable)x$1 -> x$1.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))));
        }
        catch (Exception exception) {
            With$.MODULE$.logger().warn(new StringOps("Failed to deserialize game: %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{serializedGame})));
            With$.MODULE$.logger().onException(exception);
            return None$.MODULE$;
        }
    }

    private HistoricalGame readGameFromColumns(String[] columns) {
        long id = new StringOps(Predef$.MODULE$.augmentString(columns[0])).toLong();
        int startLocations = new StringOps(Predef$.MODULE$.augmentString(columns[1])).toInt();
        String mapName = columns[2];
        String opponentName = columns[3];
        String ourRace = columns[4];
        String enemyRace = columns[5];
        boolean won = new StringOps(Predef$.MODULE$.augmentString(columns[6])).toBoolean();
        String[] tags = (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])columns)).drop(7))).map((Function1<String, String> & Serializable & scala.Serializable)x$2 -> x$2.replaceAll("Fingerprint", "Finger").replaceAll("Finger", "&"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).distinct();
        Race[] allRaces = (Race[])((Object[])new Race[]{Race.Terran, Race.Protoss, Race.Zerg, Race.Random, Race.None, Race.Unknown});
        return new HistoricalGame(id, startLocations, mapName, opponentName, (Race)((Object)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])allRaces)).find((Function1<Object, Object>)(Function1<Race, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean(HistorySerializer$.$anonfun$readGameFromColumns$2(ourRace, x$3))).getOrElse((Function0<Race> & Serializable & scala.Serializable)() -> Race.Unknown)), (Race)((Object)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])allRaces)).find((Function1<Object, Object>)(Function1<Race, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean(HistorySerializer$.$anonfun$readGameFromColumns$4(enemyRace, x$4))).getOrElse((Function0<Race> & Serializable & scala.Serializable)() -> Race.Unknown)), won, Predef$.MODULE$.wrapRefArray((Object[])tags));
    }

    public Vector<String> writeGames(Iterable<HistoricalGame> games) {
        CountMap columnLengths = new CountMap(CountMap$.MODULE$.$lessinit$greater$default$1());
        Vector<?> gameStrings = ((TraversableLike)games.toVector().sortBy((Function1<HistoricalGame, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong(HistorySerializer$.$anonfun$writeGames$1(x$5)), (Ordering)Ordering$Long$.MODULE$)).map((Function1<HistoricalGame, Vector> & Serializable & scala.Serializable)game -> MODULE$.writeGame((HistoricalGame)game), Vector$.MODULE$.canBuildFrom());
        gameStrings.foreach((Function1<Vector, Object> & Serializable & scala.Serializable)x$6 -> {
            HistorySerializer$.$anonfun$writeGames$3(columnLengths, x$6);
            return BoxedUnit.UNIT;
        });
        return gameStrings.map((Function1<Vector, String> & Serializable & scala.Serializable)x$7 -> ((TraversableOnce)((TraversableLike)x$7.zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1<Tuple2, String> & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                String cell = (String)x0$2._1();
                int index = x0$2._2$mcI$sp();
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(0).append(cell).append(MODULE$.separator()).toString())).padTo(2 + BoxesRunTime.unboxToInt(columnLengths.apply(BoxesRunTime.boxToInteger(index))), BoxesRunTime.boxToCharacter(' '), Predef$.MODULE$.StringCanBuildFrom());
            }
            throw new MatchError((Object)null);
        }, Vector$.MODULE$.canBuildFrom())).mkString(), Vector$.MODULE$.canBuildFrom());
    }

    private Vector<String> writeGame(HistoricalGame game) {
        return ((Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{Long.toString(game.timestamp()), Integer.toString(game.startLocations()), game.mapName(), game.enemyName(), game.ourRace().toString(), game.enemyRace().toString(), Boolean.toString(game.won())}))).$plus$plus(game.tags(), Vector$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$readGameFromColumns$2(String ourRace$1, Race x$3) {
        String string = x$3.toString();
        return !(string != null ? !string.equals(ourRace$1) : ourRace$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$readGameFromColumns$4(String enemyRace$1, Race x$4) {
        String string = x$4.toString();
        return !(string != null ? !string.equals(enemyRace$1) : enemyRace$1 != null);
    }

    public static final /* synthetic */ long $anonfun$writeGames$1(HistoricalGame x$5) {
        return -x$5.timestamp();
    }

    public static final /* synthetic */ void $anonfun$writeGames$4(CountMap columnLengths$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String cell = (String)x0$1._1();
            int index = x0$1._2$mcI$sp();
            columnLengths$1.update(BoxesRunTime.boxToInteger(index), BoxesRunTime.boxToInteger(Math.max(BoxesRunTime.unboxToInt(columnLengths$1.apply(BoxesRunTime.boxToInteger(index))), cell.length())));
            return;
        }
        throw new MatchError((Object)null);
    }

    public static final /* synthetic */ void $anonfun$writeGames$3(CountMap columnLengths$1, Vector x$6) {
        ((IterableLike)x$6.zipWithIndex(Vector$.MODULE$.canBuildFrom())).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
            HistorySerializer$.$anonfun$writeGames$4(columnLengths$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private HistorySerializer$() {
        MODULE$ = this;
        this.formatVersion = 4;
        this.separator = ",";
    }
}

