/*
 * Decompiled with CFR 0.152.
 */
package Debugging;

import Debugging.Asciify$;
import Debugging.ToString$;
import Lifecycle.With$;
import ProxyBwapi.Players.PlayerInfo;
import Utilities.$qmark$;
import Utilities.Time.Forever$;
import Utilities.Time.Frames;
import Utilities.Time.Seconds;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcI$sp;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u0012%\u0001\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001C\u0002\u0013%1\u0007\u0003\u0004H\u0001\u0001\u0006I\u0001\u000e\u0005\b\u0011\u0002\u0011\r\u0011\"\u00034\u0011\u0019I\u0005\u0001)A\u0005i!9!\n\u0001b\u0001\n\u0013\u0019\u0004BB&\u0001A\u0003%A\u0007C\u0004M\u0001\u0001\u0007I\u0011B'\t\u000fE\u0003\u0001\u0019!C\u0005%\"1\u0001\f\u0001Q!\n9CQ!\u0017\u0001\u0005\u0002iCqa\u0017\u0001C\u0002\u0013%A\f\u0003\u0004d\u0001\u0001\u0006I!\u0018\u0005\u0006I\u0002!\t!\u001a\u0005\u0006c\u0002!\tA\u001d\u0005\u0006i\u0002!\t!\u001e\u0005\u0006q\u0002!\t!\u001f\u0005\u0006w\u0002!\t\u0001 \u0005\u0006}\u0002!\ta \u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017A\u0011\"a\u0005\u0001\u0005\u0004%I!!\u0006\t\u000f\u0005]\u0001\u0001)A\u0005A\"9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0001\"CA\u0011\u0001E\u0005I\u0011AA\u0012\u0011\u001d\tI\u0004\u0001C\u0001\u0003wA\u0011\"!\u0011\u0001#\u0003%\t!a\t\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002F!I\u00111\n\u0001\u0012\u0002\u0013\u0005\u00111\u0005\u0005\b\u0003\u001b\u0002A\u0011BA(\u0011%\t)\u0007AI\u0001\n\u0013\t9\u0007C\u0005\u0002l\u0001\t\n\u0011\"\u0003\u0002h!I\u0011Q\u000e\u0001\u0012\u0002\u0013%\u0011q\u000e\u0005\b\u0003g\u0002A\u0011BA;\u0005\u0019aunZ4fe*\tQ%A\u0005EK\n,xmZ5oO\u000e\u00011C\u0001\u0001)!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\r\t\u0003c\u0001i\u0011\u0001J\u0001\fY><W*Z:tC\u001e,7/F\u00015!\r)$\bP\u0007\u0002m)\u0011q\u0007O\u0001\b[V$\u0018M\u00197f\u0015\tI$&\u0001\u0006d_2dWm\u0019;j_:L!a\u000f\u001c\u0003\u00151K7\u000f\u001e\"vM\u001a,'\u000f\u0005\u0002>\t:\u0011aH\u0011\t\u0003\u007f)j\u0011\u0001\u0011\u0006\u0003\u0003\u001a\na\u0001\u0010:p_Rt\u0014BA\"+\u0003\u0019\u0001&/\u001a3fM&\u0011QI\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\rS\u0013\u0001\u00047pO6+7o]1hKN\u0004\u0013a\u00059fe\u001a|'/\\1oG\u0016lUm]:bO\u0016\u001c\u0018\u0001\u00069fe\u001a|'/\\1oG\u0016lUm]:bO\u0016\u001c\b%A\u0007nS\u000e\u0014x.T3tg\u0006<Wm]\u0001\u000f[&\u001c'o\\'fgN\fw-Z:!\u00031)'O]8s\u001f\u000e,(O]3e+\u0005q\u0005CA\u0015P\u0013\t\u0001&FA\u0004C_>dW-\u00198\u0002!\u0015\u0014(o\u001c:PGV\u0014(/\u001a3`I\u0015\fHCA*W!\tIC+\u0003\u0002VU\t!QK\\5u\u0011\u001d9\u0016\"!AA\u00029\u000b1\u0001\u001f\u00132\u00035)'O]8s\u001f\u000e,(O]3eA\u0005)a\r\\;tQR\t1+\u0001\u0007mCN$\u0018J\\:uC:\u001cW-F\u0001^!\u0011)d\f\u00101\n\u0005}3$a\u0002%bg\"l\u0015\r\u001d\t\u0003S\u0005L!A\u0019\u0016\u0003\u0007%sG/A\u0007mCN$\u0018J\\:uC:\u001cW\rI\u0001\u0013cVLW\r\u001e7z\u001f:,\u0005pY3qi&|g\u000e\u0006\u0002TM\")qM\u0004a\u0001Q\u0006IQ\r_2faRLwN\u001c\t\u0003S:t!A\u001b7\u000f\u0005}Z\u0017\"A\u0016\n\u00055T\u0013a\u00029bG.\fw-Z\u0005\u0003_B\u0014\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u00055T\u0013aC8o\u000bb\u001cW\r\u001d;j_:$\"aU:\t\u000b\u001d|\u0001\u0019\u00015\u0002\u000b5L7M]8\u0015\u0005M3\b\"B<\u0011\u0001\u0004a\u0014aB7fgN\fw-Z\u0001\u0006I\u0016\u0014Wo\u001a\u000b\u0003'jDQa^\tA\u0002q\nAa^1s]R\u00111+ \u0005\u0006oJ\u0001\r\u0001P\u0001\u0006KJ\u0014xN\u001d\u000b\u0004'\u0006\u0005\u0001\"B<\u0014\u0001\u0004a\u0014a\u00039fe\u001a|'/\\1oG\u0016$2aUA\u0004\u0011\u00159H\u00031\u0001=\u0003!\u0019\u0017M\u001c*fY><G#\u0002(\u0002\u000e\u0005=\u0001\"B<\u0016\u0001\u0004a\u0004BBA\t+\u0001\u0007\u0001-A\u0006tY\u0016,\u0007O\u0012:b[\u0016\u001c\u0018A\u00053fM\u0006,H\u000e^*mK\u0016\u0004hI]1nKN,\u0012\u0001Y\u0001\u0014I\u00164\u0017-\u001e7u'2,W\r\u001d$sC6,7\u000fI\u0001\u0014I\u0016\u0014WoZ\"je\u000e,\u0018\u000e\u001e\"sK\u0006\\WM\u001d\u000b\u0006'\u0006u\u0011q\u0004\u0005\u0006ob\u0001\r\u0001\u0010\u0005\t\u0003#A\u0002\u0013!a\u0001A\u0006iB-\u001a2vO\u000eK'oY;ji\n\u0013X-Y6fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002&)\u001a\u0001-a\n,\u0005\u0005%\u0002\u0003BA\u0016\u0003ki!!!\f\u000b\t\u0005=\u0012\u0011G\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\r+\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003o\tiCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!c^1s]\u000eK'oY;ji\n\u0013X-Y6feR)1+!\u0010\u0002@!)qO\u0007a\u0001y!A\u0011\u0011\u0003\u000e\u0011\u0002\u0003\u0007\u0001-\u0001\u000fxCJt7)\u001b:dk&$(I]3bW\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0002'\u0015\u0014(o\u001c:DSJ\u001cW/\u001b;Ce\u0016\f7.\u001a:\u0015\u000bM\u000b9%!\u0013\t\u000b]d\u0002\u0019\u0001\u001f\t\u0011\u0005EA\u0004%AA\u0002\u0001\fQ$\u001a:s_J\u001c\u0015N]2vSR\u0014%/Z1lKJ$C-\u001a4bk2$HEM\u0001\u0004Y><G#C*\u0002R\u0005M\u0013qKA.\u0011\u00159h\u00041\u0001=\u0011!\t)F\bI\u0001\u0002\u0004q\u0015\u0001B2iCRD\u0001\"!\u0017\u001f!\u0003\u0005\rAT\u0001\u0007Y><7\u000f\u001e3\t\u0013\u0005uc\u0004%AA\u0002\u0005}\u0013A\u0002;be\u001e,G\u000f\u0005\u00036\u0003Cb\u0014bAA2m\t1!)\u001e4gKJ\fQ\u0002\\8hI\u0011,g-Y;mi\u0012\u0012TCAA5U\rq\u0015qE\u0001\u000eY><G\u0005Z3gCVdG\u000fJ\u001a\u0002\u001b1|w\r\n3fM\u0006,H\u000e\u001e\u00135+\t\t\tH\u000b\u0003\u0002`\u0005\u001d\u0012a\u00044pe6\fG/\u0012=dKB$\u0018n\u001c8\u0015\u0007q\n9\bC\u0003hE\u0001\u0007\u0001\u000e")
public class Logger {
    private final ListBuffer<String> logMessages = new ListBuffer();
    private final ListBuffer<String> performanceMessages = new ListBuffer();
    private final ListBuffer<String> microMessages = new ListBuffer();
    private boolean errorOcurred = false;
    private final HashMap<String, Object> lastInstance = new HashMap();
    private final int defaultSleepFrames = new Seconds(15).apply();

    private ListBuffer<String> logMessages() {
        return this.logMessages;
    }

    private ListBuffer<String> performanceMessages() {
        return this.performanceMessages;
    }

    private ListBuffer<String> microMessages() {
        return this.microMessages;
    }

    private boolean errorOcurred() {
        return this.errorOcurred;
    }

    private void errorOcurred_$eq(boolean x$1) {
        this.errorOcurred = x$1;
    }

    public void flush() {
        String opponents = "";
        try {
            opponents = ((TraversableOnce)With$.MODULE$.enemies().map((Function1<PlayerInfo, String> & Serializable & scala.Serializable)x$1 -> x$1.name(), Vector$.MODULE$.canBuildFrom())).mkString("-");
        }
        catch (Exception exception) {}
        String arg$macro$1 = With$.MODULE$.bwapiData().write();
        Object arg$macro$3 = $qmark$.MODULE$.apply(this.errorOcurred(), (Function0<String> & Serializable & scala.Serializable)() -> ".error", (Function0<String> & Serializable & scala.Serializable)() -> ".normal");
        String filename = new StringOps("%s%s%s.log.txt").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$1, opponents, arg$macro$3}));
        File file = new File(filename);
        PrintWriter printWriter = new PrintWriter(file);
        printWriter.write(this.logMessages().mkString("\r\n"));
        printWriter.write(this.microMessages().mkString("\r\n"));
        printWriter.write(this.performanceMessages().mkString("\r\n"));
        printWriter.close();
    }

    private HashMap<String, Object> lastInstance() {
        return this.lastInstance;
    }

    public void quietlyOnException(Exception exception) {
        this.error(new StringBuilder(33).append("An exception was thrown on frame ").append(With$.MODULE$.frame()).toString());
        this.error(this.formatException(exception));
    }

    public void onException(Exception exception) {
        this.quietlyOnException(exception);
    }

    public void micro(String message) {
        String x$1 = new StringOps("MICRO | %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{message}));
        boolean x$2 = false;
        ListBuffer<String> x$3 = this.microMessages();
        boolean x$4 = this.log$default$3();
        this.log(x$1, x$2, x$4, x$3);
    }

    public void debug(String message) {
        this.log(new StringOps("DEBUG | %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{message})), false, this.log$default$3(), this.log$default$4());
    }

    public void warn(String message) {
        this.log(new StringOps("WARN  | %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{message})), false, this.log$default$3(), this.log$default$4());
    }

    public void error(String message) {
        this.errorOcurred_$eq(true);
        this.log(new StringOps("ERROR | %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{message})), this.log$default$2(), this.log$default$3(), this.log$default$4());
    }

    public void performance(String message) {
        this.log(new StringOps("SPEED | %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{message})), false, false, this.performanceMessages());
    }

    private boolean canRelog(String message, int sleepFrames) {
        boolean output = BoxesRunTime.unboxToInt(this.lastInstance().getOrElse(message, (JFunction0$mcI$sp & scala.Serializable)() -> -Forever$.MODULE$.apply())) < With$.MODULE$.frame() - sleepFrames;
        this.lastInstance().update(message, BoxesRunTime.boxToInteger(With$.MODULE$.frame()));
        return output;
    }

    private int defaultSleepFrames() {
        return this.defaultSleepFrames;
    }

    public void debugCircuitBreaker(String message, int sleepFrames) {
        if (this.canRelog(message, sleepFrames)) {
            this.debug(message);
        }
        this.lastInstance().update(message, BoxesRunTime.boxToInteger(With$.MODULE$.frame()));
    }

    public int debugCircuitBreaker$default$2() {
        return this.defaultSleepFrames();
    }

    public void warnCircuitBreaker(String message, int sleepFrames) {
        if (this.canRelog(message, sleepFrames)) {
            this.warn(message);
            return;
        }
    }

    public int warnCircuitBreaker$default$2() {
        return this.defaultSleepFrames();
    }

    public void errorCircuitBreaker(String message, int sleepFrames) {
        if (this.canRelog(message, sleepFrames)) {
            this.error(message);
            return;
        }
    }

    public int errorCircuitBreaker$default$2() {
        return this.defaultSleepFrames();
    }

    private void log(String message, boolean chat, boolean logstd, Buffer<String> target) {
        Integer arg$macro$1 = BoxesRunTime.boxToInteger(With$.MODULE$.frame());
        Frames arg$macro$2 = new Frames(With$.MODULE$.frame());
        String logMessage = new StringOps("%s | %s | %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$1, arg$macro$2, message}));
        target.append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{logMessage}));
        if (With$.MODULE$.configuration().logstd() && logstd) {
            System.err.println(logMessage);
        }
        if (chat && With$.MODULE$.configuration().debugging() && With$.MODULE$.manners() != null) {
            With$.MODULE$.manners().chat(Asciify$.MODULE$.apply(message));
            return;
        }
    }

    private boolean log$default$2() {
        return true;
    }

    private boolean log$default$3() {
        return true;
    }

    private Buffer<String> log$default$4() {
        return this.logMessages();
    }

    private String formatException(Exception exception) {
        String arg$macro$4 = ToString$.MODULE$.apply(exception);
        String arg$macro$5 = exception.getMessage();
        String arg$macro$6 = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])exception.getStackTrace())).map((Function1<StackTraceElement, String> & Serializable & scala.Serializable)stackElement -> {
            String arg$macro$1 = stackElement.getClassName();
            String arg$macro$2 = stackElement.getMethodName();
            Integer arg$macro$3 = BoxesRunTime.boxToInteger(stackElement.getLineNumber());
            return new StringOps("%s.%s(): %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$1, arg$macro$2, arg$macro$3}));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n");
        return new StringOps("%s\n%s\n%s").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$4, arg$macro$5, arg$macro$6}));
    }
}

