/*
 * Decompiled with CFR 0.152.
 */
package Debugging;

import Debugging.CombatVisIO;
import Debugging.CombatVisIO$Meta$2$;
import Debugging.CombatVisIO$Meta$5$;
import Debugging.CombatVisIO$St$2$;
import Debugging.CombatVisIO$St$5$;
import Debugging.PurpleSimViz$;
import Information.Battles.Types.Battle;
import Lifecycle.With$;
import bwapi.UnitType;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPOutputStream;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Tuple2;
import scala.collection.AbstractTraversable;
import scala.collection.Iterator;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$Int$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0$mcI$sp;

public final class CombatVisIO$ {
    public static CombatVisIO$ MODULE$;
    private volatile boolean launched;
    private volatile Process visProcess;
    private volatile long lastDumpMs;
    private volatile int lastDumpGameFrame;
    private volatile long gameStartEpochSeconds;
    private final AtomicBoolean Debugging$CombatVisIO$$dumpScheduled;
    private final AtomicLong nextDumpAllowedMs;
    private final AtomicInteger simAppendCounter;
    private volatile int lastAppendStartFrame;
    private volatile String lastAppendParticipantsKey;
    private volatile int lastPwcsAppendGameFrame;
    private final LinkedBlockingQueue<Runnable> Debugging$CombatVisIO$$ioQueue;
    private final Thread ioThread;
    private final LinkedBlockingQueue<Runnable> Debugging$CombatVisIO$$dumpQueue;
    private final Thread dumpThread;

    static {
        new CombatVisIO$();
    }

    private boolean launched() {
        return this.launched;
    }

    private void launched_$eq(boolean x$1) {
        this.launched = x$1;
    }

    private Process visProcess() {
        return this.visProcess;
    }

    private void visProcess_$eq(Process x$1) {
        this.visProcess = x$1;
    }

    private File baseDir() {
        return new File(With$.MODULE$.bwapiData().write());
    }

    private File opponentFile() {
        String opp = With$.MODULE$.enemy().name().replaceAll("[^A-Za-z0-9._-]", "_");
        return new File(this.baseDir(), new java.lang.StringBuilder(5).append(opp).append(".pwcs").toString());
    }

    private long lastDumpMs() {
        return this.lastDumpMs;
    }

    private void lastDumpMs_$eq(long x$1) {
        this.lastDumpMs = x$1;
    }

    private int lastDumpGameFrame() {
        return this.lastDumpGameFrame;
    }

    private void lastDumpGameFrame_$eq(int x$1) {
        this.lastDumpGameFrame = x$1;
    }

    private long gameStartEpochSeconds() {
        return this.gameStartEpochSeconds;
    }

    private void gameStartEpochSeconds_$eq(long x$1) {
        this.gameStartEpochSeconds = x$1;
    }

    public AtomicBoolean Debugging$CombatVisIO$$dumpScheduled() {
        return this.Debugging$CombatVisIO$$dumpScheduled;
    }

    private AtomicLong nextDumpAllowedMs() {
        return this.nextDumpAllowedMs;
    }

    private AtomicInteger simAppendCounter() {
        return this.simAppendCounter;
    }

    private int lastAppendStartFrame() {
        return this.lastAppendStartFrame;
    }

    private void lastAppendStartFrame_$eq(int x$1) {
        this.lastAppendStartFrame = x$1;
    }

    private String lastAppendParticipantsKey() {
        return this.lastAppendParticipantsKey;
    }

    private void lastAppendParticipantsKey_$eq(String x$1) {
        this.lastAppendParticipantsKey = x$1;
    }

    private int lastPwcsAppendGameFrame() {
        return this.lastPwcsAppendGameFrame;
    }

    private void lastPwcsAppendGameFrame_$eq(int x$1) {
        this.lastPwcsAppendGameFrame = x$1;
    }

    public LinkedBlockingQueue<Runnable> Debugging$CombatVisIO$$ioQueue() {
        return this.Debugging$CombatVisIO$$ioQueue;
    }

    private Thread ioThread() {
        return this.ioThread;
    }

    private void enqueueIO(Runnable r) {
        try {
            this.Debugging$CombatVisIO$$ioQueue().offer(r);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public LinkedBlockingQueue<Runnable> Debugging$CombatVisIO$$dumpQueue() {
        return this.Debugging$CombatVisIO$$dumpQueue;
    }

    private Thread dumpThread() {
        return this.dumpThread;
    }

    private void enqueueDump(Runnable r) {
        try {
            this.Debugging$CombatVisIO$$dumpQueue().offer(r);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void ensureDirs() {
        try {
            if (!this.baseDir().exists()) {
                this.baseDir().mkdirs();
            }
            if (this.gameStartEpochSeconds() == 0L) {
                this.gameStartEpochSeconds_$eq(System.currentTimeMillis() / 1000L);
            }
        }
        catch (Exception exception) {
            With$.MODULE$.logger().quietlyOnException(exception);
        }
    }

    public void exportMapData() {
        try {
            this.ensureDirs();
            String hash = With$.MODULE$.game().mapHash();
            File outFile = new File(this.baseDir(), new java.lang.StringBuilder(7).append(hash).append(".mapbin").toString());
            if (outFile.exists()) {
                return;
            }
            try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(outFile));){
                int tileW = With$.MODULE$.mapTileWidth();
                int tileH = With$.MODULE$.mapTileHeight();
                int walkW = With$.MODULE$.mapWalkWidth();
                int walkH = With$.MODULE$.mapWalkHeight();
                dos.writeInt(tileW);
                dos.writeInt(tileH);
                dos.writeInt(walkW);
                dos.writeInt(walkH);
                for (int y = 0; y < tileH; ++y) {
                    for (int x = 0; x < tileW; ++x) {
                        int h = With$.MODULE$.game().getGroundHeight(x, y) & 0xFF;
                        dos.writeByte(h);
                    }
                }
                for (int wy = 0; wy < walkH; ++wy) {
                    for (int wx = 0; wx < walkW; ++wx) {
                        int w = With$.MODULE$.game().isWalkable(wx, wy) ? 1 : 0;
                        dos.writeByte(w);
                    }
                }
            }
            return;
        }
        catch (Exception exception) {
            With$.MODULE$.logger().quietlyOnException(exception);
            return;
        }
    }

    public void prepareEmptySimFile() {
        try {
            this.ensureDirs();
            String hash = With$.MODULE$.game().mapHash();
            File f = this.opponentFile();
            StringBuilder content = new StringBuilder();
            content.append("PW2\n").append("H|").append(hash).append('\n').append("Z\n");
            FileOutputStream fos = new FileOutputStream(f, false);
            try {
                fos.write(content.toString().getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable) {
                try {
                    fos.close();
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
        }
        catch (Exception exception) {
            With$.MODULE$.logger().quietlyOnException(exception);
        }
    }

    public void Debugging$CombatVisIO$$writeSimulationLogPrepared(String outPath, String mapHash, ArrayBuffer<String> framesLog, int startGameFrame) {
        try {
            LazyRef Meta$module = new LazyRef();
            LazyRef St$module = new LazyRef();
            System.nanoTime();
            boolean interesting = false;
            for (int li_guard = 0; li_guard < framesLog.length() && !interesting; ++li_guard) {
                String[] parts = framesLog.apply(li_guard).split("\\|");
                if (parts.length < 3) continue;
                String[] tokens = new StringOps(Predef$.MODULE$.augmentString(parts[2])).split(';');
                for (int ti = 0; ti < tokens.length && !interesting; ++ti) {
                    String t = tokens[ti];
                    if (!new StringOps(Predef$.MODULE$.augmentString(t)).nonEmpty() || t.length() < 2 || t.charAt(1) != ':' || t.charAt(0) != 'a' && t.charAt(0) != 'd') continue;
                    interesting = true;
                }
            }
            if (!interesting) {
                return;
            }
            ArrayBuffer buf = new ArrayBuffer();
            framesLog.headOption().foreach((Function1<String, Object> & Serializable & scala.Serializable)line -> {
                CombatVisIO$.$anonfun$writeSimulationLogPrepared$1(this, buf, Meta$module, line);
                return BoxedUnit.UNIT;
            });
            Vector<?> metas = ((TraversableOnce)((SeqLike)buf.distinct()).sortBy((Function1<Debugging_CombatVisIO$Meta$1, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger(CombatVisIO$.$anonfun$writeSimulationLogPrepared$3(x$1)), Ordering$Int$.MODULE$)).toVector();
            String participantsKey = ((TraversableOnce)((SeqLike)metas.map((Function1<Debugging_CombatVisIO$Meta$1, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger(CombatVisIO$.$anonfun$writeSimulationLogPrepared$4(x$2)), Vector$.MODULE$.canBuildFrom())).sorted(Ordering$Int$.MODULE$)).mkString(",");
            if (startGameFrame - this.lastAppendStartFrame() < With$.MODULE$.configuration().simulationRecordingPeriod()) {
                String string = participantsKey;
                String string2 = this.lastAppendParticipantsKey();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return;
                }
            }
            if (startGameFrame - this.lastPwcsAppendGameFrame() < With$.MODULE$.configuration().simulationRecordingPeriod()) {
                return;
            }
            StringBuilder sb = new StringBuilder(65536);
            sb.append("PW2\n");
            sb.append("H|").append(mapHash).append('\n');
            sb.append("S|").append(startGameFrame).append('\n');
            metas.foreach((Function1<Debugging_CombatVisIO$Meta$1, StringBuilder> & Serializable & scala.Serializable)m -> sb.append("U|").append(m.id()).append('|').append(m.friendly() ? (char)'1' : (char)'0').append('|').append(Math.max(0, m.typeId())).append('\n'));
            public class Debugging_CombatVisIO$St$1
            implements Product,
            scala.Serializable {
                private int x;
                private int y;
                private boolean alive;
                private int hp;
                private int sh;
                private int tgt;
                private int cd;

                public int x() {
                    return this.x;
                }

                public void x_$eq(int x$1) {
                    this.x = x$1;
                }

                public int y() {
                    return this.y;
                }

                public void y_$eq(int x$1) {
                    this.y = x$1;
                }

                public boolean alive() {
                    return this.alive;
                }

                public void alive_$eq(boolean x$1) {
                    this.alive = x$1;
                }

                public int hp() {
                    return this.hp;
                }

                public void hp_$eq(int x$1) {
                    this.hp = x$1;
                }

                public int sh() {
                    return this.sh;
                }

                public void sh_$eq(int x$1) {
                    this.sh = x$1;
                }

                public int tgt() {
                    return this.tgt;
                }

                public void tgt_$eq(int x$1) {
                    this.tgt = x$1;
                }

                public int cd() {
                    return this.cd;
                }

                public void cd_$eq(int x$1) {
                    this.cd = x$1;
                }

                public Debugging_CombatVisIO$St$1 copy(int x, int y, boolean alive, int hp, int sh, int tgt, int cd) {
                    return new Debugging_CombatVisIO$St$1(x, y, alive, hp, sh, tgt, cd);
                }

                public int copy$default$1() {
                    return this.x();
                }

                public int copy$default$2() {
                    return this.y();
                }

                public boolean copy$default$3() {
                    return this.alive();
                }

                public int copy$default$4() {
                    return this.hp();
                }

                public int copy$default$5() {
                    return this.sh();
                }

                public int copy$default$6() {
                    return this.tgt();
                }

                public int copy$default$7() {
                    return this.cd();
                }

                public String productPrefix() {
                    return "St";
                }

                public int productArity() {
                    return 7;
                }

                public Object productElement(int x$1) {
                    switch (x$1) {
                        case 0: {
                            return BoxesRunTime.boxToInteger(this.x());
                        }
                        case 1: {
                            return BoxesRunTime.boxToInteger(this.y());
                        }
                        case 2: {
                            return BoxesRunTime.boxToBoolean(this.alive());
                        }
                        case 3: {
                            return BoxesRunTime.boxToInteger(this.hp());
                        }
                        case 4: {
                            return BoxesRunTime.boxToInteger(this.sh());
                        }
                        case 5: {
                            return BoxesRunTime.boxToInteger(this.tgt());
                        }
                        case 6: {
                            return BoxesRunTime.boxToInteger(this.cd());
                        }
                    }
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }

                public Iterator<Object> productIterator() {
                    return ScalaRunTime$.MODULE$.typedProductIterator(this);
                }

                public boolean canEqual(Object x$1) {
                    return x$1 instanceof Debugging_CombatVisIO$St$1;
                }

                public int hashCode() {
                    return Statics.finalizeHash(Statics.mix(Statics.mix(Statics.mix(Statics.mix(Statics.mix(Statics.mix(Statics.mix(-889275714, this.x()), this.y()), this.alive() ? 1231 : 1237), this.hp()), this.sh()), this.tgt()), this.cd()), 7);
                }

                public String toString() {
                    return ScalaRunTime$.MODULE$._toString(this);
                }

                public boolean equals(Object x$1) {
                    block3: {
                        block2: {
                            if (this == x$1) break block2;
                            if (!(x$1 instanceof Debugging_CombatVisIO$St$1)) break block3;
                            Debugging_CombatVisIO$St$1 var2_2 = (Debugging_CombatVisIO$St$1)x$1;
                            if (this.x() != var2_2.x() || this.y() != var2_2.y() || this.alive() != var2_2.alive() || this.hp() != var2_2.hp() || this.sh() != var2_2.sh() || this.tgt() != var2_2.tgt() || this.cd() != var2_2.cd() || !var2_2.canEqual(this)) break block3;
                        }
                        return true;
                    }
                    return false;
                }

                public Debugging_CombatVisIO$St$1(int x, int y, boolean alive, int hp, int sh, int tgt, int cd) {
                    this.x = x;
                    this.y = y;
                    this.alive = alive;
                    this.hp = hp;
                    this.sh = sh;
                    this.tgt = tgt;
                    this.cd = cd;
                    Product.$init$(this);
                }
            }
            HashMap<Integer, Debugging_CombatVisIO$St$1> last = new HashMap<Integer, Debugging_CombatVisIO$St$1>();
            for (int flIdx = 0; flIdx < framesLog.length(); ++flIdx) {
                int n;
                String[] parts = framesLog.apply(flIdx).split("\\|");
                if (parts.length < 2) continue;
                try {
                    n = new StringOps(Predef$.MODULE$.augmentString(parts[0])).toInt();
                }
                catch (Exception exception) {
                    n = 0;
                }
                int fnum = n;
                sb.append("F|").append(fnum).append('\n');
                String[] units = new StringOps(Predef$.MODULE$.augmentString(parts[1])).split(';');
                StringBuilder changes = new StringBuilder();
                for (int i = 0; i < units.length; ++i) {
                    int n2;
                    int n3;
                    int n4;
                    int n5;
                    boolean bl;
                    int n6;
                    int n7;
                    int id;
                    int n8;
                    String[] f;
                    String u = units[i];
                    if (!new StringOps(Predef$.MODULE$.augmentString(u)).nonEmpty() || (f = new StringOps(Predef$.MODULE$.augmentString(u)).split(',')).length < 14) continue;
                    try {
                        n8 = new StringOps(Predef$.MODULE$.augmentString(f[0])).toInt();
                    }
                    catch (Exception exception) {
                        n8 = id = -1;
                    }
                    if (id < 0) continue;
                    try {
                        n7 = new StringOps(Predef$.MODULE$.augmentString(f[2])).toInt();
                    }
                    catch (Exception exception) {
                        n7 = 0;
                    }
                    int x = n7;
                    try {
                        n6 = new StringOps(Predef$.MODULE$.augmentString(f[3])).toInt();
                    }
                    catch (Exception exception) {
                        n6 = 0;
                    }
                    int y = n6;
                    try {
                        bl = new StringOps(Predef$.MODULE$.augmentString(f[4])).toBoolean();
                    }
                    catch (Exception exception) {
                        bl = true;
                    }
                    boolean alive = bl;
                    try {
                        n5 = new StringOps(Predef$.MODULE$.augmentString(f[7])).toInt();
                    }
                    catch (Exception exception) {
                        n5 = -1;
                    }
                    int hp = n5;
                    try {
                        n4 = new StringOps(Predef$.MODULE$.augmentString(f[8])).toInt();
                    }
                    catch (Exception exception) {
                        n4 = -1;
                    }
                    int sh = n4;
                    try {
                        n3 = new StringOps(Predef$.MODULE$.augmentString(f[11])).toInt();
                    }
                    catch (Exception exception) {
                        n3 = -1;
                    }
                    int tgt = n3;
                    try {
                        n2 = new StringOps(Predef$.MODULE$.augmentString(f[13])).toInt();
                    }
                    catch (Exception exception) {
                        n2 = -1;
                    }
                    int cd = n2;
                    Debugging_CombatVisIO$St$1 prev = (Debugging_CombatVisIO$St$1)last.get(BoxesRunTime.boxToInteger(id));
                    if (!(prev == null || prev.x() != x || prev.y() != y || prev.alive() != alive || prev.hp() != hp || prev.sh() != sh || prev.tgt() != tgt || prev.cd() != cd)) continue;
                    if (changes.nonEmpty()) {
                        changes.append(';');
                    }
                    changes.append(id).append(',').append(x).append(',').append(y).append(',').append(alive ? (char)'1' : '0').append(',').append(hp).append(',').append(sh).append(',').append(tgt).append(',').append(cd);
                    if (prev == null) {
                        last.put(BoxesRunTime.boxToInteger(id), this.St$3(St$module).apply(x, y, alive, hp, sh, tgt, cd));
                        continue;
                    }
                    prev.x_$eq(x);
                    prev.y_$eq(y);
                    prev.alive_$eq(alive);
                    prev.hp_$eq(hp);
                    prev.sh_$eq(sh);
                    prev.tgt_$eq(tgt);
                    prev.cd_$eq(cd);
                }
                if (changes.nonEmpty()) {
                    sb.append("C|").append(changes.toString()).append('\n');
                }
                if (parts.length < 3) continue;
                String[] tokens = new StringOps(Predef$.MODULE$.augmentString(parts[2])).split(';');
                AbstractTraversable aSB = null;
                AbstractTraversable dSB = null;
                for (int ai = 0; ai < tokens.length; ++ai) {
                    String t = tokens[ai];
                    if (!new StringOps(Predef$.MODULE$.augmentString(t)).nonEmpty()) continue;
                    if (t.startsWith("a:")) {
                        String pv = t.substring(2);
                        if (pv.indexOf(62) <= 0) continue;
                        if (aSB == null) {
                            aSB = new StringBuilder();
                        } else {
                            ((StringBuilder)aSB).append(';');
                        }
                        ((StringBuilder)aSB).append(pv);
                        continue;
                    }
                    if (!t.startsWith("d:")) continue;
                    String id = t.substring(2);
                    if (dSB == null) {
                        dSB = new StringBuilder();
                    } else {
                        ((StringBuilder)dSB).append(';');
                    }
                    ((StringBuilder)dSB).append(id);
                }
                if (aSB != null && aSB.nonEmpty()) {
                    sb.append("A|").append(((StringBuilder)aSB).toString()).append('\n');
                }
                if (dSB == null || !dSB.nonEmpty()) continue;
                sb.append("D|").append(((StringBuilder)dSB).toString()).append('\n');
            }
            sb.append("Z\n");
            byte[] bytes = sb.toString().getBytes(StandardCharsets.UTF_8);
            FileOutputStream fos = new FileOutputStream(new File(outPath), true);
            try {
                fos.write(bytes);
            }
            catch (Throwable throwable) {
                try {
                    fos.close();
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
            try {
                this.simAppendCounter().incrementAndGet();
                this.lastAppendStartFrame_$eq(startGameFrame);
                this.lastAppendParticipantsKey_$eq(participantsKey);
                this.lastPwcsAppendGameFrame_$eq(startGameFrame);
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {}
    }

    public void writeSimulationLogAsync(Battle battle, ArrayBuffer<String> framesLog, int startGameFrame) {
        try {
            String string;
            String string2;
            this.ensureDirs();
            if (this.gameStartEpochSeconds() == 0L) {
                this.gameStartEpochSeconds_$eq(System.currentTimeMillis() / 1000L);
            }
            try {
                string2 = With$.MODULE$.game().mapHash();
            }
            catch (Throwable throwable) {
                string2 = "";
            }
            String mapHash = string2;
            try {
                string = this.opponentFile().getAbsolutePath();
            }
            catch (Throwable throwable) {
                string = new File(With$.MODULE$.bwapiData().write(), new java.lang.StringBuilder(5).append(With$.MODULE$.enemy().name()).append(".pwcs").toString()).getAbsolutePath();
            }
            String outPath = string;
            ArrayBuffer copy = new ArrayBuffer(framesLog.length());
            copy.$plus$plus$eq((TraversableOnce)framesLog);
            this.enqueueIO(new Runnable(outPath, mapHash, copy, startGameFrame){
                private final String outPath$1;
                private final String mapHash$1;
                private final ArrayBuffer copy$1;
                private final int startGameFrame$1;

                public void run() {
                    CombatVisIO$.MODULE$.Debugging$CombatVisIO$$writeSimulationLogPrepared(this.outPath$1, this.mapHash$1, this.copy$1, this.startGameFrame$1);
                }
                {
                    this.outPath$1 = outPath$1;
                    this.mapHash$1 = mapHash$1;
                    this.copy$1 = copy$1;
                    this.startGameFrame$1 = startGameFrame$1;
                }
            });
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void writeCompressedSimDumpIfNeededAsync(Battle battle, ArrayBuffer<String> framesLog, int startGameFrame) {
        try {
            String string;
            int n;
            String string2;
            String string3;
            long now = System.currentTimeMillis();
            long nextAllowed = this.nextDumpAllowedMs().get();
            if (now < nextAllowed) {
                return;
            }
            if (!this.Debugging$CombatVisIO$$dumpScheduled().compareAndSet(false, true)) {
                return;
            }
            this.nextDumpAllowedMs().set(now + 10000L);
            this.ensureDirs();
            if (this.gameStartEpochSeconds() == 0L) {
                this.gameStartEpochSeconds_$eq(System.currentTimeMillis() / 1000L);
            }
            try {
                string3 = this.baseDir().getAbsolutePath();
            }
            catch (Throwable throwable) {
                string3 = With$.MODULE$.bwapiData().write();
            }
            String basePath = string3;
            try {
                string2 = With$.MODULE$.enemy().name().replaceAll("[^A-Za-z0-9._-]", "_");
            }
            catch (Throwable throwable) {
                string2 = "opponent";
            }
            String oppSan = string2;
            try {
                n = With$.MODULE$.frame();
            }
            catch (Throwable throwable) {
                n = 0;
            }
            int curFrame = n;
            try {
                string = With$.MODULE$.game().mapHash();
            }
            catch (Throwable throwable) {
                string = "";
            }
            String mapHash = string;
            long gsEpoch = this.gameStartEpochSeconds();
            ArrayBuffer copy = new ArrayBuffer(framesLog.length());
            copy.$plus$plus$eq((TraversableOnce)framesLog);
            this.enqueueDump(new Runnable(basePath, oppSan, curFrame, mapHash, gsEpoch, copy, startGameFrame){
                private final String basePath$1;
                private final String oppSan$1;
                private final int curFrame$1;
                private final String mapHash$2;
                private final long gsEpoch$1;
                private final ArrayBuffer copy$2;
                private final int startGameFrame$2;

                public void run() {
                    try {
                        CombatVisIO$.MODULE$.Debugging$CombatVisIO$$writeCompressedSimDumpIfNeededPrepared(this.basePath$1, this.oppSan$1, this.curFrame$1, this.mapHash$2, this.gsEpoch$1, this.copy$2, this.startGameFrame$2);
                    }
                    finally {
                        CombatVisIO$.MODULE$.Debugging$CombatVisIO$$dumpScheduled().set(false);
                    }
                }
                {
                    this.basePath$1 = basePath$1;
                    this.oppSan$1 = oppSan$1;
                    this.curFrame$1 = curFrame$1;
                    this.mapHash$2 = mapHash$2;
                    this.gsEpoch$1 = gsEpoch$1;
                    this.copy$2 = copy$2;
                    this.startGameFrame$2 = startGameFrame$2;
                }
            });
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void Debugging$CombatVisIO$$writeCompressedSimDumpIfNeededPrepared(String basePath, String opponentSanitized, int currentFrame, String mapHash, long startEpochSeconds, ArrayBuffer<String> framesLog, int startGameFrame) {
        try {
            LazyRef Meta$module = new LazyRef();
            LazyRef St$module = new LazyRef();
            if (currentFrame - this.lastDumpGameFrame() < 240) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now - this.lastDumpMs() < 10000L) {
                return;
            }
            System.nanoTime();
            ArrayBuffer metasBuf = new ArrayBuffer();
            framesLog.headOption().foreach((Function1<String, Object> & Serializable & scala.Serializable)line -> {
                CombatVisIO$.$anonfun$writeCompressedSimDumpIfNeededPrepared$1(this, metasBuf, Meta$module, line);
                return BoxedUnit.UNIT;
            });
            Vector<?> metas = ((TraversableOnce)metasBuf.distinct()).toVector();
            Map typeIdByUnitId = ((TraversableOnce)metas.map((Function1<Debugging_CombatVisIO$Meta$4, Tuple2> & Serializable & scala.Serializable)m -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(m.id())), BoxesRunTime.boxToInteger(m.typeId())), Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            boolean nonWorkerDeath = false;
            for (int li = 0; li < framesLog.length() && !nonWorkerDeath; ++li) {
                String[] parts = framesLog.apply(li).split("\\|");
                if (parts.length < 3) continue;
                String[] tokens = new StringOps(Predef$.MODULE$.augmentString(parts[2])).split(';');
                for (int ti = 0; ti < tokens.length && !nonWorkerDeath; ++ti) {
                    String t = tokens[ti];
                    if (!new StringOps(Predef$.MODULE$.augmentString(t)).nonEmpty() || !t.startsWith("d:")) continue;
                    String idStr = t.substring(2);
                    try {
                        int id = new StringOps(Predef$.MODULE$.augmentString(idStr)).toInt();
                        if (CombatVisIO$.isWorkerByTypeId$1(BoxesRunTime.unboxToInt(typeIdByUnitId.getOrElse(BoxesRunTime.boxToInteger(id), (JFunction0$mcI$sp & scala.Serializable)() -> -1)))) continue;
                        nonWorkerDeath = true;
                        continue;
                    }
                    catch (Exception exception) {}
                }
            }
            if (!nonWorkerDeath) {
                return;
            }
            StringBuilder sb = new StringBuilder(65536);
            sb.append("PW2\n");
            sb.append("H|").append(mapHash).append('\n');
            sb.append("S|").append(startGameFrame).append('\n');
            metas.foreach((Function1<Debugging_CombatVisIO$Meta$4, StringBuilder> & Serializable & scala.Serializable)m -> sb.append("U|").append(m.id()).append('|').append(m.friendly() ? (char)'1' : (char)'0').append('|').append(Math.max(0, m.typeId())).append('\n'));
            public class Debugging_CombatVisIO$St$4
            implements Product,
            scala.Serializable {
                private int x;
                private int y;
                private boolean alive;
                private int hp;
                private int sh;
                private int tgt;
                private int cd;

                public int x() {
                    return this.x;
                }

                public void x_$eq(int x$1) {
                    this.x = x$1;
                }

                public int y() {
                    return this.y;
                }

                public void y_$eq(int x$1) {
                    this.y = x$1;
                }

                public boolean alive() {
                    return this.alive;
                }

                public void alive_$eq(boolean x$1) {
                    this.alive = x$1;
                }

                public int hp() {
                    return this.hp;
                }

                public void hp_$eq(int x$1) {
                    this.hp = x$1;
                }

                public int sh() {
                    return this.sh;
                }

                public void sh_$eq(int x$1) {
                    this.sh = x$1;
                }

                public int tgt() {
                    return this.tgt;
                }

                public void tgt_$eq(int x$1) {
                    this.tgt = x$1;
                }

                public int cd() {
                    return this.cd;
                }

                public void cd_$eq(int x$1) {
                    this.cd = x$1;
                }

                public Debugging_CombatVisIO$St$4 copy(int x, int y, boolean alive, int hp, int sh, int tgt, int cd) {
                    return new Debugging_CombatVisIO$St$4(x, y, alive, hp, sh, tgt, cd);
                }

                public int copy$default$1() {
                    return this.x();
                }

                public int copy$default$2() {
                    return this.y();
                }

                public boolean copy$default$3() {
                    return this.alive();
                }

                public int copy$default$4() {
                    return this.hp();
                }

                public int copy$default$5() {
                    return this.sh();
                }

                public int copy$default$6() {
                    return this.tgt();
                }

                public int copy$default$7() {
                    return this.cd();
                }

                public String productPrefix() {
                    return "St";
                }

                public int productArity() {
                    return 7;
                }

                public Object productElement(int x$1) {
                    switch (x$1) {
                        case 0: {
                            return BoxesRunTime.boxToInteger(this.x());
                        }
                        case 1: {
                            return BoxesRunTime.boxToInteger(this.y());
                        }
                        case 2: {
                            return BoxesRunTime.boxToBoolean(this.alive());
                        }
                        case 3: {
                            return BoxesRunTime.boxToInteger(this.hp());
                        }
                        case 4: {
                            return BoxesRunTime.boxToInteger(this.sh());
                        }
                        case 5: {
                            return BoxesRunTime.boxToInteger(this.tgt());
                        }
                        case 6: {
                            return BoxesRunTime.boxToInteger(this.cd());
                        }
                    }
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }

                public Iterator<Object> productIterator() {
                    return ScalaRunTime$.MODULE$.typedProductIterator(this);
                }

                public boolean canEqual(Object x$1) {
                    return x$1 instanceof Debugging_CombatVisIO$St$4;
                }

                public int hashCode() {
                    return Statics.finalizeHash(Statics.mix(Statics.mix(Statics.mix(Statics.mix(Statics.mix(Statics.mix(Statics.mix(-889275714, this.x()), this.y()), this.alive() ? 1231 : 1237), this.hp()), this.sh()), this.tgt()), this.cd()), 7);
                }

                public String toString() {
                    return ScalaRunTime$.MODULE$._toString(this);
                }

                public boolean equals(Object x$1) {
                    block3: {
                        block2: {
                            if (this == x$1) break block2;
                            if (!(x$1 instanceof Debugging_CombatVisIO$St$4)) break block3;
                            Debugging_CombatVisIO$St$4 var2_2 = (Debugging_CombatVisIO$St$4)x$1;
                            if (this.x() != var2_2.x() || this.y() != var2_2.y() || this.alive() != var2_2.alive() || this.hp() != var2_2.hp() || this.sh() != var2_2.sh() || this.tgt() != var2_2.tgt() || this.cd() != var2_2.cd() || !var2_2.canEqual(this)) break block3;
                        }
                        return true;
                    }
                    return false;
                }

                public Debugging_CombatVisIO$St$4(int x, int y, boolean alive, int hp, int sh, int tgt, int cd) {
                    this.x = x;
                    this.y = y;
                    this.alive = alive;
                    this.hp = hp;
                    this.sh = sh;
                    this.tgt = tgt;
                    this.cd = cd;
                    Product.$init$(this);
                }
            }
            HashMap<Integer, Debugging_CombatVisIO$St$4> last = new HashMap<Integer, Debugging_CombatVisIO$St$4>();
            for (int fl = 0; fl < framesLog.length(); ++fl) {
                int n;
                String[] parts = framesLog.apply(fl).split("\\|");
                if (parts.length < 2) continue;
                try {
                    n = new StringOps(Predef$.MODULE$.augmentString(parts[0])).toInt();
                }
                catch (Exception exception) {
                    n = 0;
                }
                int fnum = n;
                sb.append("F|").append(fnum).append('\n');
                String[] units = new StringOps(Predef$.MODULE$.augmentString(parts[1])).split(';');
                StringBuilder changes = new StringBuilder();
                for (int i = 0; i < units.length; ++i) {
                    int n2;
                    int n3;
                    int n4;
                    int n5;
                    boolean bl;
                    int n6;
                    int n7;
                    int id;
                    int n8;
                    String[] f;
                    String u = units[i];
                    if (!new StringOps(Predef$.MODULE$.augmentString(u)).nonEmpty() || (f = new StringOps(Predef$.MODULE$.augmentString(u)).split(',')).length < 14) continue;
                    try {
                        n8 = new StringOps(Predef$.MODULE$.augmentString(f[0])).toInt();
                    }
                    catch (Exception exception) {
                        n8 = id = -1;
                    }
                    if (id < 0) continue;
                    try {
                        n7 = new StringOps(Predef$.MODULE$.augmentString(f[2])).toInt();
                    }
                    catch (Exception exception) {
                        n7 = 0;
                    }
                    int x = n7;
                    try {
                        n6 = new StringOps(Predef$.MODULE$.augmentString(f[3])).toInt();
                    }
                    catch (Exception exception) {
                        n6 = 0;
                    }
                    int y = n6;
                    try {
                        bl = new StringOps(Predef$.MODULE$.augmentString(f[4])).toBoolean();
                    }
                    catch (Exception exception) {
                        bl = true;
                    }
                    boolean alive = bl;
                    try {
                        n5 = new StringOps(Predef$.MODULE$.augmentString(f[7])).toInt();
                    }
                    catch (Exception exception) {
                        n5 = -1;
                    }
                    int hp = n5;
                    try {
                        n4 = new StringOps(Predef$.MODULE$.augmentString(f[8])).toInt();
                    }
                    catch (Exception exception) {
                        n4 = -1;
                    }
                    int sh = n4;
                    try {
                        n3 = new StringOps(Predef$.MODULE$.augmentString(f[11])).toInt();
                    }
                    catch (Exception exception) {
                        n3 = -1;
                    }
                    int tgt = n3;
                    try {
                        n2 = new StringOps(Predef$.MODULE$.augmentString(f[13])).toInt();
                    }
                    catch (Exception exception) {
                        n2 = -1;
                    }
                    int cd = n2;
                    Debugging_CombatVisIO$St$4 prev = (Debugging_CombatVisIO$St$4)last.get(BoxesRunTime.boxToInteger(id));
                    if (!(prev == null || prev.x() != x || prev.y() != y || prev.alive() != alive || prev.hp() != hp || prev.sh() != sh || prev.tgt() != tgt || prev.cd() != cd)) continue;
                    if (changes.nonEmpty()) {
                        changes.append(';');
                    }
                    changes.append(id).append(',').append(x).append(',').append(y).append(',').append(alive ? (char)'1' : '0').append(',').append(hp).append(',').append(sh).append(',').append(tgt).append(',').append(cd);
                    if (prev == null) {
                        last.put(BoxesRunTime.boxToInteger(id), this.St$6(St$module).apply(x, y, alive, hp, sh, tgt, cd));
                        continue;
                    }
                    prev.x_$eq(x);
                    prev.y_$eq(y);
                    prev.alive_$eq(alive);
                    prev.hp_$eq(hp);
                    prev.sh_$eq(sh);
                    prev.tgt_$eq(tgt);
                    prev.cd_$eq(cd);
                }
                if (changes.nonEmpty()) {
                    sb.append("C|").append(changes.toString()).append('\n');
                }
                if (parts.length < 3) continue;
                String[] tokens = new StringOps(Predef$.MODULE$.augmentString(parts[2])).split(';');
                AbstractTraversable aSB = null;
                AbstractTraversable dSB = null;
                for (int ti = 0; ti < tokens.length; ++ti) {
                    String t = tokens[ti];
                    if (!new StringOps(Predef$.MODULE$.augmentString(t)).nonEmpty()) continue;
                    if (t.startsWith("a:")) {
                        String pv = t.substring(2);
                        if (pv.indexOf(62) <= 0) continue;
                        if (aSB == null) {
                            aSB = new StringBuilder();
                        } else {
                            ((StringBuilder)aSB).append(';');
                        }
                        ((StringBuilder)aSB).append(pv);
                        continue;
                    }
                    if (!t.startsWith("d:")) continue;
                    String id = t.substring(2);
                    if (dSB == null) {
                        dSB = new StringBuilder();
                    } else {
                        ((StringBuilder)dSB).append(';');
                    }
                    ((StringBuilder)dSB).append(id);
                }
                if (aSB != null && aSB.nonEmpty()) {
                    sb.append("A|").append(((StringBuilder)aSB).toString()).append('\n');
                }
                if (dSB == null || !dSB.nonEmpty()) continue;
                sb.append("D|").append(((StringBuilder)dSB).toString()).append('\n');
            }
            int totalSec = Math.max(0, currentFrame / 24);
            int mm = totalSec / 60 % 60;
            int ss = totalSec % 60;
            Long arg$macro$2 = BoxesRunTime.boxToLong(startEpochSeconds);
            String name = new StringOps("%s-%s-%02d-%02d.pwsim").format(Predef$.MODULE$.genericWrapArray(new Object[]{opponentSanitized, arg$macro$2, BoxesRunTime.boxToInteger(mm), BoxesRunTime.boxToInteger(ss)}));
            File outFile = new File(basePath, name);
            for (int suffix = 1; outFile.exists() && suffix < 1000; ++suffix) {
                Long arg$macro$6 = BoxesRunTime.boxToLong(startEpochSeconds);
                Integer arg$macro$9 = BoxesRunTime.boxToInteger(suffix);
                String alt = new StringOps("%s-%s-%02d-%02d-%s.pwsim").format(Predef$.MODULE$.genericWrapArray(new Object[]{opponentSanitized, arg$macro$6, BoxesRunTime.boxToInteger(mm), BoxesRunTime.boxToInteger(ss), arg$macro$9}));
                outFile = new File(basePath, alt);
            }
            byte[] bytes = sb.toString().getBytes(StandardCharsets.UTF_8);
            FileOutputStream fos = new FileOutputStream(outFile);
            GZIPOutputStream gos = new GZIPOutputStream(fos);
            try {
                gos.write(bytes);
            }
            catch (Throwable throwable) {
                try {
                    gos.close();
                }
                catch (Throwable throwable2) {}
                try {
                    fos.close();
                }
                catch (Throwable throwable3) {}
                throw throwable;
            }
            try {
                gos.close();
            }
            catch (Throwable throwable) {}
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
            this.lastDumpMs_$eq(now);
            this.lastDumpGameFrame_$eq(currentFrame);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void launchVisualizer() {
        try {
            this.ensureDirs();
            String path = this.opponentFile().getAbsolutePath();
            String cp = System.getProperty("java.class.path", ".");
            ProcessBuilder pb = new ProcessBuilder("java", "-cp", cp, "Debugging.PurpleSimViz", path);
            pb.directory(this.baseDir());
            pb.redirectErrorStream(true);
            this.visProcess_$eq(pb.start());
            this.launched_$eq(true);
            return;
        }
        catch (Exception exception) {
            With$.MODULE$.logger().quietlyOnException(exception);
            return;
        }
    }

    public void terminateVisualizer() {
        block10: {
            try {
                try {
                    if (!this.launched()) break block10;
                    if (this.visProcess() != null) {
                        try {
                            this.visProcess().destroy();
                        }
                        catch (Throwable throwable) {}
                        this.visProcess_$eq(null);
                        break block10;
                    }
                    try {
                        PurpleSimViz$.MODULE$.requestClose();
                    }
                    catch (Exception exception) {
                        With$.MODULE$.logger().quietlyOnException(exception);
                    }
                }
                catch (Exception exception) {
                    With$.MODULE$.logger().quietlyOnException(exception);
                }
            }
            finally {
                this.launched_$eq(false);
            }
        }
    }

    private static final /* synthetic */ CombatVisIO$Meta$2$ Meta$lzycompute$1(LazyRef Meta$module$1) {
        synchronized (Meta$module$1) {
            CombatVisIO$Meta$2$ combatVisIO$Meta$2$ = Meta$module$1.initialized() ? (CombatVisIO$Meta$2$)Meta$module$1.value() : Meta$module$1.initialize(new CombatVisIO$Meta$2$());
            return combatVisIO$Meta$2$;
        }
    }

    private final CombatVisIO$Meta$2$ Meta$3(LazyRef Meta$module$1) {
        if (Meta$module$1.initialized()) {
            return (CombatVisIO$Meta$2$)Meta$module$1.value();
        }
        return CombatVisIO$.Meta$lzycompute$1(Meta$module$1);
    }

    public static final /* synthetic */ void $anonfun$writeSimulationLogPrepared$1(CombatVisIO$ $this, ArrayBuffer buf$1, LazyRef Meta$module$1, String line) {
        String[] parts = line.split("\\|");
        if (parts.length >= 2) {
            String[] units = new StringOps(Predef$.MODULE$.augmentString(parts[1])).split(';');
            for (int i = 0; i < units.length; ++i) {
                int typeId;
                int n;
                String string;
                int n2;
                String[] f;
                String u = units[i];
                if (!new StringOps(Predef$.MODULE$.augmentString(u)).nonEmpty() || (f = new StringOps(Predef$.MODULE$.augmentString(u)).split(',')).length < 14) continue;
                try {
                    n2 = new StringOps(Predef$.MODULE$.augmentString(f[0])).toInt();
                }
                catch (Exception exception) {
                    n2 = -1;
                }
                int id = n2;
                boolean friendly = new StringOps(Predef$.MODULE$.augmentString(f[1])).toBoolean();
                try {
                    string = f[14];
                }
                catch (Exception exception) {
                    string = (String)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])f)).lastOption().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "");
                }
                try {
                    n = UnitType.valueOf((String)string).id;
                }
                catch (Throwable throwable) {
                    n = typeId = -1;
                }
                if (id < 0) continue;
                public class Debugging_CombatVisIO$Meta$1
                implements Product,
                scala.Serializable {
                    private final int id;
                    private final boolean friendly;
                    private final int typeId;

                    public int id() {
                        return this.id;
                    }

                    public boolean friendly() {
                        return this.friendly;
                    }

                    public int typeId() {
                        return this.typeId;
                    }

                    public Debugging_CombatVisIO$Meta$1 copy(int id, boolean friendly, int typeId) {
                        return new Debugging_CombatVisIO$Meta$1(id, friendly, typeId);
                    }

                    public int copy$default$1() {
                        return this.id();
                    }

                    public boolean copy$default$2() {
                        return this.friendly();
                    }

                    public int copy$default$3() {
                        return this.typeId();
                    }

                    public String productPrefix() {
                        return "Meta";
                    }

                    public int productArity() {
                        return 3;
                    }

                    public Object productElement(int x$1) {
                        switch (x$1) {
                            case 0: {
                                return BoxesRunTime.boxToInteger(this.id());
                            }
                            case 1: {
                                return BoxesRunTime.boxToBoolean(this.friendly());
                            }
                            case 2: {
                                return BoxesRunTime.boxToInteger(this.typeId());
                            }
                        }
                        throw new IndexOutOfBoundsException(Integer.toString(x$1));
                    }

                    public Iterator<Object> productIterator() {
                        return ScalaRunTime$.MODULE$.typedProductIterator(this);
                    }

                    public boolean canEqual(Object x$1) {
                        return x$1 instanceof Debugging_CombatVisIO$Meta$1;
                    }

                    public int hashCode() {
                        return Statics.finalizeHash(Statics.mix(Statics.mix(Statics.mix(-889275714, this.id()), this.friendly() ? 1231 : 1237), this.typeId()), 3);
                    }

                    public String toString() {
                        return ScalaRunTime$.MODULE$._toString(this);
                    }

                    public boolean equals(Object x$1) {
                        block3: {
                            block2: {
                                if (this == x$1) break block2;
                                if (!(x$1 instanceof Debugging_CombatVisIO$Meta$1)) break block3;
                                Debugging_CombatVisIO$Meta$1 var2_2 = (Debugging_CombatVisIO$Meta$1)x$1;
                                if (this.id() != var2_2.id() || this.friendly() != var2_2.friendly() || this.typeId() != var2_2.typeId() || !var2_2.canEqual(this)) break block3;
                            }
                            return true;
                        }
                        return false;
                    }

                    public Debugging_CombatVisIO$Meta$1(int id, boolean friendly, int typeId) {
                        this.id = id;
                        this.friendly = friendly;
                        this.typeId = typeId;
                        Product.$init$(this);
                    }
                }
                buf$1.$plus$eq($this.Meta$3(Meta$module$1).apply(id, friendly, typeId));
            }
            return;
        }
    }

    public static final /* synthetic */ int $anonfun$writeSimulationLogPrepared$3(CombatVisIO.Meta.1 x$1) {
        return x$1.id();
    }

    public static final /* synthetic */ int $anonfun$writeSimulationLogPrepared$4(CombatVisIO.Meta.1 x$2) {
        return x$2.id();
    }

    private static final /* synthetic */ CombatVisIO$St$2$ St$lzycompute$1(LazyRef St$module$1) {
        synchronized (St$module$1) {
            CombatVisIO$St$2$ combatVisIO$St$2$ = St$module$1.initialized() ? (CombatVisIO$St$2$)St$module$1.value() : St$module$1.initialize(new CombatVisIO$St$2$());
            return combatVisIO$St$2$;
        }
    }

    private final CombatVisIO$St$2$ St$3(LazyRef St$module$1) {
        if (St$module$1.initialized()) {
            return (CombatVisIO$St$2$)St$module$1.value();
        }
        return CombatVisIO$.St$lzycompute$1(St$module$1);
    }

    private static final /* synthetic */ CombatVisIO$Meta$5$ Meta$lzycompute$2(LazyRef Meta$module$2) {
        synchronized (Meta$module$2) {
            CombatVisIO$Meta$5$ combatVisIO$Meta$5$ = Meta$module$2.initialized() ? (CombatVisIO$Meta$5$)Meta$module$2.value() : Meta$module$2.initialize(new CombatVisIO$Meta$5$());
            return combatVisIO$Meta$5$;
        }
    }

    private final CombatVisIO$Meta$5$ Meta$6(LazyRef Meta$module$2) {
        if (Meta$module$2.initialized()) {
            return (CombatVisIO$Meta$5$)Meta$module$2.value();
        }
        return CombatVisIO$.Meta$lzycompute$2(Meta$module$2);
    }

    public static final /* synthetic */ void $anonfun$writeCompressedSimDumpIfNeededPrepared$1(CombatVisIO$ $this, ArrayBuffer metasBuf$1, LazyRef Meta$module$2, String line) {
        String[] parts = line.split("\\|");
        if (parts.length >= 2) {
            String[] units = new StringOps(Predef$.MODULE$.augmentString(parts[1])).split(';');
            for (int i = 0; i < units.length; ++i) {
                int typeId;
                int n;
                String string;
                int n2;
                String[] f;
                String u = units[i];
                if (!new StringOps(Predef$.MODULE$.augmentString(u)).nonEmpty() || (f = new StringOps(Predef$.MODULE$.augmentString(u)).split(',')).length < 14) continue;
                try {
                    n2 = new StringOps(Predef$.MODULE$.augmentString(f[0])).toInt();
                }
                catch (Exception exception) {
                    n2 = -1;
                }
                int id = n2;
                boolean friendly = new StringOps(Predef$.MODULE$.augmentString(f[1])).toBoolean();
                try {
                    string = f[14];
                }
                catch (Exception exception) {
                    string = (String)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])f)).lastOption().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "");
                }
                try {
                    n = UnitType.valueOf((String)string).id;
                }
                catch (Throwable throwable) {
                    n = typeId = -1;
                }
                if (id < 0) continue;
                public class Debugging_CombatVisIO$Meta$4
                implements Product,
                scala.Serializable {
                    private final int id;
                    private final boolean friendly;
                    private final int typeId;

                    public int id() {
                        return this.id;
                    }

                    public boolean friendly() {
                        return this.friendly;
                    }

                    public int typeId() {
                        return this.typeId;
                    }

                    public Debugging_CombatVisIO$Meta$4 copy(int id, boolean friendly, int typeId) {
                        return new Debugging_CombatVisIO$Meta$4(id, friendly, typeId);
                    }

                    public int copy$default$1() {
                        return this.id();
                    }

                    public boolean copy$default$2() {
                        return this.friendly();
                    }

                    public int copy$default$3() {
                        return this.typeId();
                    }

                    public String productPrefix() {
                        return "Meta";
                    }

                    public int productArity() {
                        return 3;
                    }

                    public Object productElement(int x$1) {
                        switch (x$1) {
                            case 0: {
                                return BoxesRunTime.boxToInteger(this.id());
                            }
                            case 1: {
                                return BoxesRunTime.boxToBoolean(this.friendly());
                            }
                            case 2: {
                                return BoxesRunTime.boxToInteger(this.typeId());
                            }
                        }
                        throw new IndexOutOfBoundsException(Integer.toString(x$1));
                    }

                    public Iterator<Object> productIterator() {
                        return ScalaRunTime$.MODULE$.typedProductIterator(this);
                    }

                    public boolean canEqual(Object x$1) {
                        return x$1 instanceof Debugging_CombatVisIO$Meta$4;
                    }

                    public int hashCode() {
                        return Statics.finalizeHash(Statics.mix(Statics.mix(Statics.mix(-889275714, this.id()), this.friendly() ? 1231 : 1237), this.typeId()), 3);
                    }

                    public String toString() {
                        return ScalaRunTime$.MODULE$._toString(this);
                    }

                    public boolean equals(Object x$1) {
                        block3: {
                            block2: {
                                if (this == x$1) break block2;
                                if (!(x$1 instanceof Debugging_CombatVisIO$Meta$4)) break block3;
                                Debugging_CombatVisIO$Meta$4 var2_2 = (Debugging_CombatVisIO$Meta$4)x$1;
                                if (this.id() != var2_2.id() || this.friendly() != var2_2.friendly() || this.typeId() != var2_2.typeId() || !var2_2.canEqual(this)) break block3;
                            }
                            return true;
                        }
                        return false;
                    }

                    public Debugging_CombatVisIO$Meta$4(int id, boolean friendly, int typeId) {
                        this.id = id;
                        this.friendly = friendly;
                        this.typeId = typeId;
                        Product.$init$(this);
                    }
                }
                metasBuf$1.$plus$eq($this.Meta$6(Meta$module$2).apply(id, friendly, typeId));
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$writeCompressedSimDumpIfNeededPrepared$4(int typeId$1, UnitType x$3) {
        return x$3.id == typeId$1;
    }

    private static final boolean isWorkerByTypeId$1(int typeId) {
        if (typeId < 0) {
            return false;
        }
        UnitType ut = (UnitType)((Object)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])UnitType.values())).find((Function1<Object, Object>)(Function1<UnitType, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean(CombatVisIO$.$anonfun$writeCompressedSimDumpIfNeededPrepared$4(typeId, x$3))).orNull(Predef$.MODULE$.$conforms()));
        return ut != null && ut.isWorker();
    }

    private static final /* synthetic */ CombatVisIO$St$5$ St$lzycompute$2(LazyRef St$module$2) {
        synchronized (St$module$2) {
            CombatVisIO$St$5$ combatVisIO$St$5$ = St$module$2.initialized() ? (CombatVisIO$St$5$)St$module$2.value() : St$module$2.initialize(new CombatVisIO$St$5$());
            return combatVisIO$St$5$;
        }
    }

    private final CombatVisIO$St$5$ St$6(LazyRef St$module$2) {
        if (St$module$2.initialized()) {
            return (CombatVisIO$St$5$)St$module$2.value();
        }
        return CombatVisIO$.St$lzycompute$2(St$module$2);
    }

    /*
     * WARNING - void declaration
     */
    private CombatVisIO$() {
        void var2_2;
        void var1_1;
        MODULE$ = this;
        this.launched = false;
        this.lastDumpMs = 0L;
        this.lastDumpGameFrame = -1000000;
        this.gameStartEpochSeconds = 0L;
        this.Debugging$CombatVisIO$$dumpScheduled = new AtomicBoolean(false);
        this.nextDumpAllowedMs = new AtomicLong(0L);
        this.simAppendCounter = new AtomicInteger(0);
        this.lastAppendStartFrame = -1000000;
        this.lastAppendParticipantsKey = "";
        this.lastPwcsAppendGameFrame = -1000000;
        this.Debugging$CombatVisIO$$ioQueue = new LinkedBlockingQueue();
        Thread t = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            CombatVisIO$.MODULE$.Debugging$CombatVisIO$$ioQueue().take().run();
                        }
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                    break;
                }
            }
        });
        t.setName("CombatVisIO-IO-Append");
        t.setDaemon(true);
        t.start();
        this.ioThread = var1_1;
        this.Debugging$CombatVisIO$$dumpQueue = new LinkedBlockingQueue();
        Thread t2 = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            CombatVisIO$.MODULE$.Debugging$CombatVisIO$$dumpQueue().take().run();
                        }
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                    break;
                }
            }
        });
        t2.setName("CombatVisIO-IO-Dump");
        t2.setDaemon(true);
        t2.start();
        this.dumpThread = var2_2;
    }
}

